<?php
/**
 * WordFoundry Settings Handler
 */

if (!defined('ABSPATH')) {
    exit;
}

class WordFoundry_Settings {
    /**
     * Option name
     */
    const OPTION_NAME = 'wordfoundry_settings';

    /**
     * Get all settings
     */
    public static function get_all() {
        $defaults = array(
            'api_url' => 'https://wordfoundry.app',
            'site_id' => '',
            'webhook_secret' => '',
            'sync_enabled' => true,
        );

        $settings = get_option(self::OPTION_NAME, array());
        return wp_parse_args($settings, $defaults);
    }

    /**
     * Get single setting
     */
    public static function get($key, $default = null) {
        $settings = self::get_all();
        return isset($settings[$key]) ? $settings[$key] : $default;
    }

    /**
     * Update setting
     */
    public static function set($key, $value) {
        $settings = self::get_all();
        $settings[$key] = $value;
        return update_option(self::OPTION_NAME, $settings);
    }

    /**
     * Update multiple settings
     */
    public static function update($new_settings) {
        $settings = self::get_all();
        $settings = wp_parse_args($new_settings, $settings);
        return update_option(self::OPTION_NAME, $settings);
    }

    /**
     * Check if plugin is configured
     */
    public static function is_configured() {
        $settings = self::get_all();
        return !empty($settings['site_id']) && !empty($settings['webhook_secret']);
    }

    /**
     * Get webhook URL for this site
     */
    public static function get_webhook_url() {
        $site_id = self::get('site_id');
        $api_url = self::get('api_url', 'https://wordfoundry.app');

        if (empty($site_id)) {
            return '';
        }

        return rtrim($api_url, '/') . '/api/v1/sites/webhook/' . $site_id;
    }
}
