<?php
/**
 * WordFoundry Settings Page Template
 */

if (!defined('ABSPATH')) {
    exit;
}

$settings = WordFoundry_Settings::get_all();
$is_configured = WordFoundry_Settings::is_configured();
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>

    <?php if (!$is_configured): ?>
        <div class="notice notice-warning">
            <p>
                <strong><?php esc_html_e('Setup Required', 'wordfoundry-connect'); ?></strong><br>
                <?php esc_html_e('Please enter your Site ID and Webhook Secret to connect to WordFoundry.', 'wordfoundry-connect'); ?>
            </p>
        </div>
    <?php else: ?>
        <div class="notice notice-success">
            <p>
                <strong><?php esc_html_e('Connected', 'wordfoundry-connect'); ?></strong><br>
                <?php esc_html_e('Your site is connected to WordFoundry.', 'wordfoundry-connect'); ?>
            </p>
        </div>
    <?php endif; ?>

    <div class="wordfoundry-settings-container">
        <div class="wordfoundry-settings-main">
            <form method="post" action="options.php">
                <?php
                settings_fields('wordfoundry_settings_group');
                do_settings_sections('wordfoundry-settings');
                submit_button();
                ?>
            </form>
        </div>

        <div class="wordfoundry-settings-sidebar">
            <div class="wordfoundry-card">
                <h3><?php esc_html_e('Quick Setup', 'wordfoundry-connect'); ?></h3>
                <ol>
                    <li><?php esc_html_e('Log in to WordFoundry', 'wordfoundry-connect'); ?></li>
                    <li><?php esc_html_e('Go to Sites and add your WordPress site', 'wordfoundry-connect'); ?></li>
                    <li><?php esc_html_e('Copy the Site ID and Webhook Secret', 'wordfoundry-connect'); ?></li>
                    <li><?php esc_html_e('Paste them in the fields on the left', 'wordfoundry-connect'); ?></li>
                    <li><?php esc_html_e('Save settings and start publishing!', 'wordfoundry-connect'); ?></li>
                </ol>
            </div>

            <div class="wordfoundry-card">
                <h3><?php esc_html_e('Application Password', 'wordfoundry-connect'); ?></h3>
                <p><?php esc_html_e('WordFoundry uses WordPress Application Passwords to publish content securely.', 'wordfoundry-connect'); ?></p>
                <p>
                    <a href="<?php echo esc_url(admin_url('profile.php#application-passwords-section')); ?>" class="button">
                        <?php esc_html_e('Manage Application Passwords', 'wordfoundry-connect'); ?>
                    </a>
                </p>
            </div>

            <div class="wordfoundry-card">
                <h3><?php esc_html_e('REST API Endpoint', 'wordfoundry-connect'); ?></h3>
                <p><?php esc_html_e('Your site\'s WordFoundry API endpoint:', 'wordfoundry-connect'); ?></p>
                <code style="display: block; padding: 10px; background: #f1f1f1; word-break: break-all;">
                    <?php echo esc_url(rest_url('wordfoundry/v1/')); ?>
                </code>
            </div>

            <?php if ($is_configured): ?>
                <div class="wordfoundry-card">
                    <h3><?php esc_html_e('Webhook URL', 'wordfoundry-connect'); ?></h3>
                    <p><?php esc_html_e('WordFoundry will send updates to:', 'wordfoundry-connect'); ?></p>
                    <code style="display: block; padding: 10px; background: #f1f1f1; word-break: break-all;">
                        <?php echo esc_url(WordFoundry_Settings::get_webhook_url()); ?>
                    </code>
                </div>
            <?php endif; ?>

            <div class="wordfoundry-card">
                <h3><?php esc_html_e('Need Help?', 'wordfoundry-connect'); ?></h3>
                <p>
                    <a href="https://wordfoundry.app/docs" target="_blank" rel="noopener">
                        <?php esc_html_e('Documentation', 'wordfoundry-connect'); ?>
                    </a>
                </p>
                <p>
                    <a href="https://wordfoundry.app/support" target="_blank" rel="noopener">
                        <?php esc_html_e('Contact Support', 'wordfoundry-connect'); ?>
                    </a>
                </p>
            </div>
        </div>
    </div>
</div>

<style>
    .wordfoundry-settings-container {
        display: flex;
        gap: 30px;
        margin-top: 20px;
    }

    .wordfoundry-settings-main {
        flex: 1;
        max-width: 800px;
    }

    .wordfoundry-settings-sidebar {
        width: 300px;
    }

    .wordfoundry-card {
        background: #fff;
        border: 1px solid #ccd0d4;
        border-radius: 4px;
        padding: 15px 20px;
        margin-bottom: 20px;
    }

    .wordfoundry-card h3 {
        margin-top: 0;
        padding-bottom: 10px;
        border-bottom: 1px solid #eee;
    }

    .wordfoundry-card ol {
        padding-left: 20px;
    }

    .wordfoundry-card ol li {
        margin-bottom: 8px;
    }

    @media (max-width: 960px) {
        .wordfoundry-settings-container {
            flex-direction: column;
        }

        .wordfoundry-settings-sidebar {
            width: 100%;
        }
    }
</style>
